/************************************************************************
 *
 * \file: mspin_demo_testbed.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: mySPIN - Demo application
 *
 * \author: Bui Le Thuan / RBVH/ENG2 / Thuan.BuiLe@vn.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef MSPIN_TESTBED_H_
#define MSPIN_TESTBED_H_

#include <glib-unix.h>
#include "libtestbedapp.h"
#include "Singleton.h"

class Testbed : public Singleton<Testbed>{
public:

    Testbed();
    virtual ~Testbed();

    void setTestbedMode(bool inTestbedMode);
    bool getTestbedMode();

    int getSurfaceID();
    int getLayerID();

    void setState(int inState);
    int getState();

    void setConnectedAndroidPhone(bool inAndroidPhone);
    bool getConnectedAndroidPhone();

    void setAndroidPhoneDisconnectionStatus(bool inAndroidPhoneDisconnection);
    bool getAndroidPhoneDisconnectionStatus();

    void setApplePhoneDisconnectionStatus(bool inApplePhoneDisconnection);
    bool getApplePhoneDisconnectionStatus();

    void adit_testbed_init();
    void adit_testbed_run();
    void adit_testbed_deinit();

    void adit_testbed_available();
    void adit_testbed_background();
    void adit_testbed_foreground();
    void adit_testbed_lost();

private:

    bool m_myspin_testbed_mode;
    GMainLoop *m_myspin_g_main_loop_ctx;
    int m_myspin_layer_id;
    int m_myspin_surface_id;
    int m_myspin_state;

    bool m_myspin_is_AndroidPhone;
    bool m_myspin_android_phone_disconnect;
    bool m_myspin_apple_phone_disconnect;


    static void state_changed_TB(tba_app_state_t previous_state, tba_app_state_t new_state, void *user_data);
    static bool entering_shutdown_TB(int request_id, void *user_data);
    static bool waking_up_TB(tba_app_state_t recent_active_state, tba_app_state_t *targeted_state, int request_id, void *user_data);
    static void surface_id_received_TB(unsigned int surface_id, void *user_data);
    static void surface_id_invalid_TB(unsigned int surface_id, void *user_data);
    static void log_event_TB(tba_loglevel_t level, const char *msg, void *user_data);
};

#endif /* MSPIN_TESTBED_H_ */
